#ifndef RAT_ENV_MESSAGE_H
#define RAT_ENV_MESSAGE_H

/* Modified: CGP, 9/19/00
 *		Interface is changed from using directions (N, S, E, W)
 *		to having calls relative to the rat's body orientation,
 *		E.g., Rotate relative to the rat's current body orientation.
 * Change, CGP, 12/17/00
 *      RatEnvMessage constructor takes BLooper parameter now. This will
 *      change when PortMessage and PortableMessage changes are incorporated.
 */

#include "EnvMessage.h"

#define RAT_ENV_MESSAGE_API_VER 1

class Environment;

class RatEnvMessage : public EnvMessage {
	public:
		RatEnvMessage(BLooper *env);
		int Ver() { return RAT_ENV_MESSAGE_API_VER; }
		
		// Messages sent to environment
		
		// rotate rat from current heading: +ve is right, -ve is left
		void Rotate(int degees);
		
		bool IsOpen(); 		// Is there a door open in the direction we are facing
							// (must be at center).
							
		bool Move(); 		// Move in the direction we're facing.
							// If the rat is in the center and facing a door,
							// this moves him from the center to the end of the
							// maze arm. If the rat is at the end of arm, and facing
							// towards the door of the arm, this moves him back to
							// the center of the maze.
							// Returns true iff move performed successfully.
							
      	bool FoodHere(); 	// Check if there is food at current location.
      	bool EatFood(); 	// Eat food at current location. Returns true iff
      						// food consumed successfully.
      	float *Look();		// Look in current direction (get landmarks in view)
};

#endif